<?php

namespace ColemanProjects\Taxi\Validator;

use Laminas\Validator\AbstractValidator;

class IntegerBetween extends AbstractValidator
{
    public const MSG_NUMERIC = 'msgNumeric';
    public const MSG_MINIMUM_VALUE = 'msgMinValue';
    public const MSG_MAXIMUM_VALUE = 'msgMaxValue';

    public $minimum_value;
    public $maximum_value;

    protected $messageVariables = [
        'min' => 'minimum_value',
        'max' => 'maximum_value'
    ];

    protected $messageTemplates = [
        self::MSG_NUMERIC => "'%value%' must be an integer",
        self::MSG_MINIMUM_VALUE => "'%value%' must be at least '%min%'",
        self::MSG_MAXIMUM_VALUE => "'%value%' must be no more than '%max%'"
    ];

    public function __construct($options)
    {
        parent::__construct($options);

        $this->minimum_value = $options['min'];
        $this->maximum_value = $options['max'];
    }

    public function isValid($value)
    {
        $this->setValue($value);

        if (filter_var($value, FILTER_VALIDATE_INT) === false) {
            $this->error(self::MSG_NUMERIC);
            return false;
        }

        if ($value < $this->minimum_value) {
            $this->error(self::MSG_MINIMUM_VALUE);
            return false;
        }

        if ($value > $this->maximum_value) {
            $this->error(self::MSG_MAXIMUM_VALUE);
            return false;
        }

        return true;
    }
}
