<?php

namespace ColemanProjects\Taxi\Validator;

use Laminas\Validator\AbstractValidator;

class PhoneNumber extends AbstractValidator
{
    public const MSG_DIGITS = 'msgDigits';
    public const MSG_MINIMUM_LENGTH = 'msgMinLength';
    public const MSG_MAXIMUM_LENGTH = 'msgMaxLength';

    public $minimum_length = 10;
    public $maximum_length = 15;

    protected $messageVariables = [
        'min' => 'minimum_length',
        'max' => 'maximum_length'
    ];

    protected $messageTemplates = [
        self::MSG_DIGITS => "'%value%' must only consist of digits",
        self::MSG_MINIMUM_LENGTH => "'%value%' must be at least '%min%' digits",
        self::MSG_MAXIMUM_LENGTH => "'%value%' must be no more than '%max%' digits"
    ];

    public function isValid($value)
    {
        $this->setValue($value);

        if (!preg_match('/^([0-9\s]+)$/', $value)) {
            $this->error(self::MSG_DIGITS);
            return false;
        }

        if (strlen($value) < $this->minimum_length) {
            $this->error(self::MSG_MINIMUM_LENGTH);
            return false;
        }

        if (strlen($value) > $this->maximum_length) {
            $this->error(self::MSG_MAXIMUM_LENGTH);
            return false;
        }

        return true;
    }
}
